<?php
/* 
 * outsourced used functions to keep mainfile clean
 */


/**
* Returns the HTML Part of the page e.g. header / footer
*
* @param  	bool	$what "0=Header 1=Footer"
* @return 	string requested HTML Code
* @access 	public
* @author 	author Marco Götze, solariz.de
*/
function getHTML($what=0,$title=false) {
    $OUT = "";
    if($what == 0) {
        $OUT .= '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">';
        $OUT .= "\n<html>\n\t<head>\n";
        $OUT .= "\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n";
        if($title != false) $OUT .= "\t\t<title>".$title."</title>\n";
        $OUT .= "\t</head>\n<body>\n";
    } ELSE {
        $OUT .= "\n</body>\n</html>\n";
    }
    return $OUT;
}


/**
* Returns a Error message for use in die() with footer part
*
* @param  	string $msg The error message
* @return 	string HTML code with footer
* @access 	public
* @author 	author Marco Götze, solariz.de
*/
function throwERROR($msg) {
    $OUT = "";
    $OUT .= "<li>".$msg;
    $OUT .= getHTML(1);
    return $OUT;
}


/**
* Build the MySQL query for insert into WP
* @param    string $table Name of the table to insert into
* @param  	array $array Array with keys and values  e.g. "post_title"=>"test post"
* @return 	string SQL Query
* @access 	public
* @author 	author Marco Götze, solariz.de
*/
function wpBuildQuery($table,$array) {
    if(!is_array($array)) die(throwERROR("wpBuildQuery called without array()"));
    $query = "INSERT INTO `".$table."` set ";
    foreach ($array as $k => $v) {
        if($k AND $v) {
            if($inserted > 0) $query .= ",";
            $query .= "`".$k."` = '".mysql_escape_string(str_replace("`","",$v))."'";
            ++$inserted;
        }
    }
    return $query;
}



